/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.fmtwidgets;

import com.quantumdata.fmteditor.MsgLog;
import com.quantumdata.fmteditor.fmtwidgets.FmtTransferable;
import com.quantumdata.std.QDUtil;
import com.quantumdata.widgets.QDButton;
import com.quantumdata.widgets.QDList;
import com.quantumdata.widgets.QDListItem;
import com.quantumdata.widgets.QDPanel;
import com.quantumdata.widgets.QDStdUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class ListBuilder
extends QDPanel {
    public static final String MODIFIED = "qd_modified";
    protected QDList m_pickList;
    protected QDList m_buildList;
    private JLabel m_pickLabel;
    private JLabel m_buildLabel;
    private QDPanel m_cmdPanel;
    private int m_ypos = 0;
    private Action m_addAction;
    private Action m_removeAction;
    private Action m_clearAction;
    private Action m_upAction;
    private Action m_downAction;
    private boolean m_modified = false;

    public ListBuilder() {
        this.initComponents();
    }

    public void setPickTitle(String string) {
        this.m_pickLabel.setText(string);
    }

    public void setBuildTitle(String string) {
        this.m_buildLabel.setText(string);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        QDPanel qDPanel = new QDPanel((LayoutManager)new BorderLayout());
        QDPanel qDPanel2 = new QDPanel((LayoutManager)new BorderLayout());
        this.m_pickList = new QDList();
        this.m_pickList.setFont(new Font("Serif", 1, 12));
        this.m_pickList.setSingleSelect();
        this.m_pickList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListBuilder.this.updateButtonStates();
            }
        });
        qDPanel2.add((Component)new JScrollPane((Component)this.m_pickList), (Object)"Center");
        this.m_pickList.setTransferHandler((TransferHandler)new ListTransfer(false));
        this.m_pickList.setDragEnabled(true);
        this.m_pickList.setName("PickList");
        this.m_pickList.useSmallItems(true);
        this.m_pickLabel = new JLabel("Pick List");
        this.m_pickLabel.setFont(new Font("Serif", 1, 16));
        this.m_pickLabel.setForeground(QDStdUI.getActionForeground());
        this.m_pickLabel.setBackground(QDStdUI.getButtonDark());
        this.m_pickLabel.setOpaque(true);
        this.m_pickLabel.setHorizontalAlignment(0);
        qDPanel2.add((Component)this.m_pickLabel, (Object)"North");
        qDPanel.add((Component)qDPanel2, (Object)"Center");
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.m_cmdPanel = new QDPanel((LayoutManager)gridBagLayout);
        this.m_cmdPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        qDPanel.add((Component)this.m_cmdPanel, (Object)"East");
        this.addCommands();
        QDPanel qDPanel3 = new QDPanel((LayoutManager)new BorderLayout());
        this.m_buildList = new QDList();
        this.m_buildList.setFont(new Font("Serif", 1, 12));
        this.m_buildList.setSingleSelect();
        this.m_buildList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListBuilder.this.updateButtonStates();
            }
        });
        this.m_buildList.setTransferHandler((TransferHandler)new ListTransfer(true));
        this.m_buildList.setDragEnabled(true);
        this.m_buildList.setName("BuildList");
        this.m_buildList.useSmallItems(true);
        this.m_buildList.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127) {
                    ListBuilder.this.removeSelectedBuildItem();
                }
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        JScrollPane jScrollPane = new JScrollPane((Component)this.m_buildList);
        qDPanel3.add((Component)jScrollPane, (Object)"Center");
        this.m_buildLabel = new JLabel("Build List");
        this.m_buildLabel.setOpaque(true);
        this.m_buildLabel.setFont(new Font("Serif", 1, 16));
        this.m_buildLabel.setForeground(QDStdUI.getActionForeground());
        this.m_buildLabel.setBackground(QDStdUI.getButtonDark());
        this.m_buildLabel.setHorizontalAlignment(0);
        qDPanel3.add((Component)this.m_buildLabel, (Object)"North");
        JSplitPane jSplitPane = new JSplitPane(1, true, (Component)qDPanel, (Component)qDPanel3);
        jSplitPane.setForeground(QDStdUI.getActionForeground());
        jSplitPane.setBackground(QDStdUI.getButtonDark());
        jSplitPane.setDividerSize(3);
        if (jSplitPane.getUI() instanceof BasicSplitPaneUI) {
            BasicSplitPaneUI basicSplitPaneUI = (BasicSplitPaneUI)jSplitPane.getUI();
            basicSplitPaneUI.getDivider().setBorder(BorderFactory.createLineBorder(QDStdUI.getActionForeground(), 1));
            basicSplitPaneUI.getDivider().setBackground(QDStdUI.getButtonDark());
            basicSplitPaneUI.getDivider().setForeground(QDStdUI.getButtonDark());
        }
        this.add(jSplitPane, "Center");
    }

    protected void addCmdComponent(JComponent jComponent) {
        GridBagLayout gridBagLayout = (GridBagLayout)this.m_cmdPanel.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.m_ypos++;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.m_cmdPanel.add((Component)jComponent);
    }

    private void addCommands() {
        this.m_addAction = new AddAction();
        QDButton qDButton = new QDButton(this.m_addAction);
        this.m_addAction.setEnabled(false);
        this.addCmdComponent((JComponent)qDButton);
        this.m_removeAction = new RemoveAction();
        qDButton = new QDButton(this.m_removeAction);
        this.m_removeAction.setEnabled(false);
        this.addCmdComponent((JComponent)qDButton);
        this.m_clearAction = new ClearAction();
        qDButton = new QDButton(this.m_clearAction);
        this.m_clearAction.setEnabled(false);
        this.addCmdComponent((JComponent)qDButton);
        this.m_upAction = new UpAction();
        qDButton = new QDButton(this.m_upAction);
        this.m_upAction.setEnabled(false);
        this.addCmdComponent((JComponent)qDButton);
        this.m_downAction = new DownAction();
        qDButton = new QDButton(this.m_downAction);
        this.m_downAction.setEnabled(false);
        this.addCmdComponent((JComponent)qDButton);
    }

    private void removeSelectedBuildItem() {
        QDListItem qDListItem = (QDListItem)this.m_buildList.getSelectedValue();
        if (qDListItem == null) {
            return;
        }
        this.removeSelected(qDListItem);
    }

    public void addBuildItem(QDListItem qDListItem) {
        this.addBuildItem(qDListItem, -1);
    }

    public void addBuildItem(QDListItem qDListItem, int n) {
        int n2;
        QDListItem qDListItem2 = (QDListItem)this.m_pickList.getItem(qDListItem.toString());
        if (qDListItem2 != null) {
            qDListItem2.setMarked(true);
            this.m_pickList.repaint();
        }
        if (n < 0) {
            this.m_buildList.getData().addElement(qDListItem);
            n2 = -1;
        } else {
            this.m_buildList.getData().insertElementAt(qDListItem, n);
            n2 = n;
        }
        this.m_buildList.setSelectedIndex(n2);
        this.setModified(true);
    }

    public void markPick(String string, boolean bl) {
        QDListItem qDListItem = (QDListItem)this.m_pickList.getItem(string);
        if (qDListItem != null) {
            qDListItem.setMarked(bl);
            this.m_pickList.repaint();
        }
    }

    public void unmarkAllPicks() {
        int n = this.m_pickList.getData().size();
        for (int i = 0; i < n; ++i) {
            QDListItem qDListItem = (QDListItem)this.m_pickList.getData().getElementAt(i);
            qDListItem.setMarked(false);
        }
        this.m_pickList.repaint();
    }

    protected void addSelected(QDListItem qDListItem) {
        QDListItem qDListItem2 = new QDListItem(qDListItem.getText(), qDListItem.getIcon());
        this.addBuildItem(qDListItem2);
    }

    protected void removeSelected(QDListItem qDListItem) {
        this.removeBuildItem(qDListItem, qDListItem.toString());
    }

    protected void removeBuildItem(QDListItem qDListItem, String string) {
        QDListItem qDListItem2 = (QDListItem)this.m_pickList.getItem(string);
        if (qDListItem2 != null) {
            qDListItem2.setMarked(false);
            this.m_pickList.repaint();
        }
        this.setModified(true);
        int n = this.m_buildList.getSelectedIndex();
        this.m_buildList.getData().removeElement(qDListItem);
        int n2 = this.m_buildList.getData().size();
        if (n2 == 0) {
            return;
        }
        if (n > n2 - 1) {
            n = n2 - 1;
        }
        this.m_buildList.setSelectedIndex(n);
    }

    protected void moveSelected(QDListItem qDListItem, boolean bl) {
        if (bl) {
            this.m_buildList.moveSelectedUp();
        } else {
            this.m_buildList.moveSelectedDown();
        }
        this.setModified(true);
    }

    protected void updateButtonStates() {
        QDListItem qDListItem = (QDListItem)this.m_pickList.getSelectedValue();
        if (qDListItem != null) {
            this.m_addAction.setEnabled(!qDListItem.isMarked());
        } else {
            this.m_addAction.setEnabled(false);
        }
        qDListItem = (QDListItem)this.m_buildList.getSelectedValue();
        if (qDListItem != null) {
            this.m_removeAction.setEnabled(!qDListItem.isMarked());
            int n = this.m_buildList.getSelectedIndex();
            this.m_upAction.setEnabled(n > 0);
            this.m_downAction.setEnabled(n < this.m_buildList.getData().size() - 1);
        } else {
            this.m_removeAction.setEnabled(false);
            this.m_upAction.setEnabled(false);
            this.m_downAction.setEnabled(false);
        }
        this.m_clearAction.setEnabled(this.anyUnmarkedBuildItems());
    }

    public int getPickCount() {
        return this.m_pickList.getData().size();
    }

    public QDListItem getPickItem(int n) {
        if (n < 0 || n >= this.getPickCount()) {
            return null;
        }
        return (QDListItem)this.m_pickList.getData().getElementAt(n);
    }

    public void addPickItem(QDListItem qDListItem) {
        this.m_pickList.getData().addElement(qDListItem);
        QDListItem qDListItem2 = (QDListItem)this.m_buildList.getItem(qDListItem.getText());
        if (qDListItem2 != null) {
            qDListItem.setMarked(true);
            this.m_pickList.repaint();
        }
    }

    public void clearPickList() {
        this.m_pickList.getData().clear();
    }

    public int getBuildCount() {
        return this.m_buildList.getData().size();
    }

    public QDListItem getBuildItem(int n) {
        if (n < 0 || n >= this.getBuildCount()) {
            return null;
        }
        return (QDListItem)this.m_buildList.getData().getElementAt(n);
    }

    public void clearBuildList() {
        this.m_buildList.getData().clear();
        this.setModified(true);
    }

    public void selectBuildItem(int n) {
        if (n < 0 || n >= this.getBuildCount()) {
            return;
        }
        this.m_buildList.setSelectedIndex(n);
    }

    public boolean isModified() {
        return this.m_modified;
    }

    public void markUnmodified() {
        this.setModified(false);
    }

    protected boolean anyUnmarkedBuildItems() {
        int n = this.m_buildList.getData().size();
        for (int i = 0; i < n; ++i) {
            QDListItem qDListItem = (QDListItem)this.m_buildList.getData().get(i);
            if (qDListItem.isMarked()) continue;
            return true;
        }
        return false;
    }

    private void setModified(boolean bl) {
        if (this.m_modified != bl) {
            boolean bl2 = this.m_modified;
            this.m_modified = bl;
            this.firePropertyChange(MODIFIED, bl2, this.m_modified);
        }
    }

    protected boolean itemDropped(String string, int n) {
        this.addBuildItem(new QDListItem(string), n);
        return true;
    }

    private class Selector
    implements Runnable {
        private int m_index;

        public Selector(int n) {
            this.m_index = n;
        }

        public void run() {
            if (this.m_index < 0) {
                this.m_index = ListBuilder.this.m_buildList.getData().size() - 1;
            }
            ListBuilder.this.m_buildList.setSelectedIndex(this.m_index);
            ListBuilder.this.setModified(true);
        }
    }

    private class ListTransfer
    extends TransferHandler {
        private boolean m_dropAllowed;
        private boolean m_isSource = false;
        private int m_srcIndex;

        public ListTransfer(boolean bl) {
            this.m_dropAllowed = bl;
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            if (!this.m_dropAllowed) {
                return false;
            }
            for (DataFlavor dataFlavor : dataFlavorArray) {
                if (!dataFlavor.equals(FmtTransferable.FLAVOR)) continue;
                return true;
            }
            return false;
        }

        protected Transferable createTransferable(JComponent jComponent) {
            this.m_isSource = true;
            QDList qDList = (QDList)jComponent;
            this.m_srcIndex = qDList.getSelectedIndex();
            QDListItem qDListItem = (QDListItem)qDList.getSelectedValue();
            String string = qDListItem == null ? "" : qDListItem.getText();
            return new FmtTransferable(string);
        }

        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            this.m_isSource = false;
        }

        public int getSourceActions(JComponent jComponent) {
            if (this.m_dropAllowed) {
                return 2;
            }
            return 1;
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            try {
                String string = (String)transferable.getTransferData(FmtTransferable.FLAVOR);
                QDList qDList = (QDList)jComponent;
                int n = qDList.getSelectedIndex();
                if (this.m_isSource && n == this.m_srcIndex) {
                    return false;
                }
                if (n >= 0 && n == qDList.getData().size() - 1) {
                    Point point = MouseInfo.getPointerInfo().getLocation();
                    Point point2 = qDList.getLocationOnScreen();
                    Rectangle rectangle = qDList.getCellBounds(n, n);
                    if (!rectangle.contains(point.x - point2.x, point.y - point2.y)) {
                        n = -1;
                    }
                }
                if (!ListBuilder.this.itemDropped(string, n)) {
                    return false;
                }
                if (this.m_isSource) {
                    if (n >= 0) {
                        if (this.m_srcIndex > n) {
                            ++this.m_srcIndex;
                        } else {
                            --n;
                        }
                    }
                    ListBuilder.this.m_buildList.getData().removeElementAt(this.m_srcIndex);
                    SwingUtilities.invokeLater(new Selector(n));
                } else if (n < 0) {
                    SwingUtilities.invokeLater(new Selector(n));
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                MsgLog.error("Internal Error: " + unsupportedFlavorException.getMessage());
            }
            catch (IOException iOException) {
                MsgLog.error("Internal Error: " + iOException.getMessage());
            }
            return false;
        }
    }

    private class DownAction
    extends AbstractAction {
        public DownAction() {
            super("Move Down");
            this.putValue("SmallIcon", QDUtil.loadIcon((String)"sortDown.png"));
            this.putValue("ShortDescription", "Move the selected item down in the list");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            QDListItem qDListItem = (QDListItem)ListBuilder.this.m_buildList.getSelectedValue();
            if (qDListItem == null) {
                return;
            }
            ListBuilder.this.moveSelected(qDListItem, false);
        }
    }

    private class UpAction
    extends AbstractAction {
        public UpAction() {
            super("Move Up  ");
            this.putValue("SmallIcon", QDUtil.loadIcon((String)"sortUp.png"));
            this.putValue("ShortDescription", "Move the selected item up in the list");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            QDListItem qDListItem = (QDListItem)ListBuilder.this.m_buildList.getSelectedValue();
            if (qDListItem == null) {
                return;
            }
            ListBuilder.this.moveSelected(qDListItem, true);
        }
    }

    private class ClearAction
    extends AbstractAction {
        public ClearAction() {
            super("Remove All");
            this.putValue("ShortDescription", "Remove all items from the list");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = JOptionPane.showConfirmDialog((Component)((Object)ListBuilder.this), "Are you sure you want to remove ALL items?", "Remove All...", 0);
            if (n == 1) {
                return;
            }
            int n2 = ListBuilder.this.m_buildList.getData().size();
            for (int i = n2 - 1; i >= 0; --i) {
                QDListItem qDListItem = (QDListItem)ListBuilder.this.m_buildList.getData().get(i);
                if (qDListItem.isMarked()) continue;
                ListBuilder.this.m_buildList.getData().remove(i);
            }
            ListBuilder.this.unmarkAllPicks();
            ListBuilder.this.setModified(true);
        }
    }

    private class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            super(" << Remove << ");
            this.putValue("ShortDescription", "Remove the selected item from the list");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ListBuilder.this.removeSelectedBuildItem();
        }
    }

    private class AddAction
    extends AbstractAction {
        public AddAction() {
            super(" >> Add >> ");
            this.putValue("ShortDescription", "Append the selected item to the list");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            QDListItem qDListItem = (QDListItem)ListBuilder.this.m_pickList.getSelectedValue();
            if (qDListItem == null) {
                return;
            }
            ListBuilder.this.addSelected(qDListItem);
        }
    }
}

